function errortot=fminTWfunc(parin,scalefac,param,tspan,y0)

% Load experimental data
str = param.expdat;
eval(str); % load experimental results stored in seperate file 

estpar=parin.*scalefac; % rescale parameters (set to one, so not used now)
% Replace parameters by estimates
 switch param.fitcase % 1=diffusion only, 2=diffusion+OCT3, 3=transporters only SERT, OCT3 and MVM efflux, 4=everything,diffusion and all transporters 
        case 1 %diffusion only, other parameters set to zero
            param.PdifA=estpar(1);      % [dm min^-1] diffusive permeability A
            param.PdifB=param.PdifA;    % [dm min^-1] diffusive permeability B
            param.PdifC=param.PdifA;    % [dm min^-1] diffusive permeability C            
        case 2 %= diffusion + OCT3
            param.PdifA=estpar(1);      % [dm min^-1] diffusive permeability A
            param.PdifB=param.PdifA;    % [dm min^-1] diffusive permeability B
            param.PdifC=param.PdifA;    % [dm min^-1] diffusive permeability C
            param.Xt_BM=estpar(2);      % OCT3 transporters on BM
        case 3 %=transporters only SERT, OCT3 and MVM efflux            
            param.Xt_BM=estpar(1);      % OCT3 transporters on BM
            param.Xt_MVM=estpar(2);     % SERT transporters on MVM
            param.VefMVM=estpar(3);     % efflux transporter on MVM
        case 4 % everything,diffusion and all transporters              
            param.PdifA=estpar(1);      % [dm min^-1] diffusive permeability A
            param.PdifB=param.PdifA;    % [dm min^-1] diffusive permeability B
            param.PdifC=param.PdifA;    % [dm min^-1] diffusive permeability C
            param.Xt_BM=estpar(2);      % OCT3 transporters on BM
            param.Xt_MVM=estpar(3);     % SERT transporters on MVM
            param.VefMVM=estpar(4);     % efflux transporter on MVM
 end
 
% --- Calculate results ---
odeoptions=[];
[tout, yout]=ode45(@kinetics_perfusion,tspan,y0,odeoptions,param); 

%  calculate maternal compartment error
if param.perfcase==1
    tindex=1:12;   % Maternal to fetal phase
    texp=tmaternal(tindex);
    yhlpexp=Cmaternal(tindex);
    y1=yout(:,param.ind1(1));
    yhlpcomp=interp1(tout,y1,texp); % interpolate to match experimental timepoints
    errorM=sum((yhlpcomp-yhlpexp).^2)./sum(yhlpexp.^2);
    
    tindex=13:24;  % Fetal to maternal phase
    texp=tmaternal(tindex);
    yhlpexp=Cmaternal(tindex);
    y1=yout(:,param.ind1(1));
    yhlpcomp=interp1(tout,y1,texp); % interpolate to match experimental timepoints 
    errorM=errorM + sum((yhlpcomp-yhlpexp).^2)./sum(yhlpexp.^2);
    
elseif param.perfcase==2 
    tindex=1:29;   % Not including final boli
    texp=tmaternal(tindex);
    yhlpexp=Cmaternal(tindex);
    y1=yout(:,param.ind1(1));
    yhlpcomp=interp1(tout,y1,texp); % interpolate to match experimental timepoints 
    errorM=sum((yhlpcomp-yhlpexp).^2)./sum(yhlpexp.^2);    
end


% calculate fetal compartment error
if param.perfcase==1
    tindex=1:12;    % Maternal to fetal phase
    texp=tfetal(tindex);
    yhlpexp=Cfetal(tindex);
    y3=yout(:,param.ind3(1));
    yhlpcomp=interp1(tout,y3,texp); % interpolate to match experimental timepoints 
    errorF=sum((yhlpcomp-yhlpexp).^2)./sum(yhlpexp.^2);
    
    tindex=13:24;  % Fetal to maternal phase
    texp=tfetal(tindex);
    yhlpexp=Cfetal(tindex);
    y3=yout(:,param.ind3(1));
    yhlpcomp=interp1(tout,y3,texp); % interpolate to match experimental timepoints 
    errorF=errorF + sum((yhlpcomp-yhlpexp).^2)./sum(yhlpexp.^2);

elseif param.perfcase==2
    tindex=1:29;   % Not including final boli
    texp=tfetal(tindex);
    yhlpexp=Cfetal(tindex);
    y3=yout(:,param.ind3(1));
    yhlpcomp=interp1(tout,y3,texp); % interpolate to match experimental timepoints 
    errorF=sum((yhlpcomp-yhlpexp).^2)./sum(yhlpexp.^2);    
end

% calculate total error
errortot=errorM+errorF;

